/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class Base64Decode
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__base64Decode";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 2;
    private CompoundVariable[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables variables;
        String variableName;
        String sourceString = this.values[0].execute();
        String decodedValue = new String(Base64.decodeBase64((String)sourceString));
        if (this.values.length > 1 && (variableName = this.values[1].execute()).length() > 0 && (variables = this.getVariables()) != null) {
            variables.put(variableName, decodedValue);
        }
        return decodedValue;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add("Base64 string to be decoded");
        desc.add("Name of variable in which to store the result (optional)");
    }
}

