/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.modifiers.FifoPopPreProcessor;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.testelement.TestElement;

public class FifoPopPreProcessorGui
extends AbstractPreProcessorGui {
    public static final String WIKIPAGE = "InterThreadCommunication";
    private JTextField queueName;
    private JTextField variableName;
    private JTextField timeout;

    public FifoPopPreProcessorGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Inter-Thread Communication PreProcessor");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof FifoPopPreProcessor) {
            FifoPopPreProcessor el = (FifoPopPreProcessor)element;
            this.queueName.setText(el.getQueueName());
            this.variableName.setText(el.getVarName());
            this.timeout.setText(el.getTimeout());
        }
    }

    public TestElement createTestElement() {
        FifoPopPreProcessor preproc = new FifoPopPreProcessor();
        this.modifyTestElement((TestElement)preproc);
        preproc.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return preproc;
    }

    public void modifyTestElement(TestElement te) {
        this.configureTestElement(te);
        if (te instanceof FifoPopPreProcessor) {
            FifoPopPreProcessor preproc = (FifoPopPreProcessor)te;
            preproc.setTimeout(this.timeout.getText());
            preproc.setVarName(this.variableName.getText());
            preproc.setQueueName(this.queueName.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("FIFO Queue Name to Get Data From: ", 4));
        this.queueName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.queueName);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Variable Name to Store Data: ", 4));
        this.variableName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.variableName);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Timeout: ", 4));
        this.timeout = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.timeout);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    private void initFields() {
        this.queueName.setText("SYNC_FIFO");
        this.variableName.setText("gotData");
        this.timeout.setText("");
    }
}

